
<?php
// CONTROLEUR PARENT DES CONTROLEURS

abstract class Controller
{
    // POUR CREER UN PARAMETRE PAR DEFAUT SI PAS UTILISE
    protected function render(string $path, array $data = [])
    {
        extract($data);

        // ON STOCKE LE CODE A PARTIR DE MAINTENANT, SANS L'ENVOYER AU NAVIGATEUR
        ob_start();

        // POUR ACCEDER A LA RACINE DU SITE
        include dirname(__DIR__) . '/views/' . $path . ".php";

        // ON AFFECTE A $content CE QU'ON A STOCKE, ON VIDE LE TAMPON ET ON ARRETE LA MISE EN TAMPON
        $content = ob_get_clean();

        include dirname(__DIR__) . '/views/base.php';
    }

    public function redirectedToRoute($controller, $action, $param = "")
    {

        header('HTTP/1.0 301 Moved Permanently');
        header('Location: index.php?controller=' . $controller . '&action=' . $action . "&message=" . $param);
        header('Connection: close');
        die();
    }
}
