<?php

class AppointmentModel extends DbConnect
{
    public function all()
    {
        $this->request = $this->connection->prepare("SELECT rendez_vous.id_rendez_vous, rendez_vous.date_rendez_vous, rendez_vous.nom_rendez_vous, rendez_vous.lieu_rendez_vous, rendez_vous.notes_rendez_vous, types.nom_type FROM rendez_vous INNER JOIN types ON rendez_vous.id_type = types.id_type; ASC");
        $this->request->execute();
        return $this->request->fetchAll();
    }

    public function one(Appointment $appointment)
    {
        $this->request = $this->connection->prepare("SELECT * FROM `rendez_vous` WHERE id_rendez_vous = :id");
        $this->request->bindValue("id", $_GET["id"]);
        $this->request->execute();
        return $this->request->fetch();
    }

    public function create(Appointment $appointment)
    {
        try {
            $this->request = $this->connection->prepare("INSERT INTO `rendez_vous`( `date_rendez_vous`, `nom_rendez_vous`, `lieu_rendez_vous`, `notes_rendez_vous`, `id_type`) VALUES (:date, :name, :place, :notes, :id_type)");
            $this->request->bindValue("date", $appointment->getDate());
            $this->request->bindValue("name", $appointment->getName());
            $this->request->bindValue("place", $appointment->getPlace());
            $this->request->bindValue("notes", $appointment->getNotes());
            $this->request->bindValue("id_type", $appointment->getIdType());
            $this->request->execute();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }

    public function delete(Appointment $appointment)
    {
        try {
            $this->request = $this->connection->prepare("DELETE FROM `rendez_vous` WHERE id_rendez_vous = :id");
            $this->request->bindValue("id", $appointment->getId());
            $this->request->execute();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }

    public function update(Appointment $appointment)
    {
        try {
            $this->request = $this->connection->prepare("UPDATE `rendez_vous` SET `date_rendez_vous`= :date,`nom_rendez_vous`= :name,`lieu_rendez_vous`= :place,`notes_rendez_vous`= :notes,`id_type`= :id_type WHERE `id_rendez_vous` = :id");
            $this->request->bindValue("id", $appointment->getId());
            $this->request->bindValue("date", $appointment->getDate());
            $this->request->bindValue("name", $appointment->getName());
            $this->request->bindValue("place", $appointment->getPlace());
            $this->request->bindValue("notes", $appointment->getNotes());
            $this->request->bindValue("id_type", $appointment->getIdType());
            $this->request->execute();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }
}
