<?php

class TypeModel extends DbConnect
{
    public function all()
    {
        $this->request = $this->connection->prepare("SELECT * FROM `types` ORDER BY `types`.`id_type` ASC");
        $this->request->execute();
        return $this->request->fetchAll();
    }

    public function one(Type $type)
    {
        try {
            $this->request = $this->connection->prepare("SELECT * FROM `types` WHERE id_type = :id");
            $this->request->bindValue("id", $type->getId());
            $this->request->execute();
            return $this->request->fetch();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }

    public function create(Type $type)
    {
        try {
            $this->request = $this->connection->prepare("INSERT INTO `types`(`nom_type`) VALUES (:name)");
            $this->request->bindValue("name", $type->getName());
            $this->request->execute();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }

    public function update(Type $type)
    {
        try {
            $this->request = $this->connection->prepare("UPDATE `types` SET `nom_type`= :name WHERE types.id_type = :id");
            $this->request->bindValue("name", $type->getName());
            $this->request->bindValue("id", $type->getId());
            $this->request->execute();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }

    public function delete(Type $type)
    {
        try {
            $this->request = $this->connection->prepare("DELETE FROM `types` WHERE id_type = :id");
            $this->request->bindValue("id", $type->getId());
            $this->request->execute();
        } catch (Exception $error) {
            echo "<p>" . $error . "</p>";
            die;
        }
    }
}
